#include "ODECylinder.h"

namespace PhysicsEngine
{

ODECylinder::ODECylinder()
{
}

ODECylinder::ODECylinder(dWorldID world, int objectid, float radius, float length, Vector3f position,Vector3f rotation, int materialid, float mass, Vector3f linearvelocity, Vector3f angularvelocity):IPhysicalCylinder(objectid, radius, length, position, rotation, materialid, mass)
{
	dGeomID geomid = dCreateCCylinder (0, radius, length);
	//space #0 does not insert box into a space

	if (mass>0) 
	{
		dMass m;
		dBodyID idBody= dBodyCreate (world);
		dBodySetPosition (idBody,position.GetFirst(),position.GetSecond(),position.GetThird());
		dMassSetCylinderTotal(&m, mass, 3,radius,length);
		dMassAdjust (&m,mass);
		dBodySetMass (idBody,&m);		
		dGeomSetBody (geomid,idBody);
		dBodySetLinearVel(idBody, linearvelocity.GetFirst(), linearvelocity.GetSecond(), linearvelocity.GetThird());
		dBodySetAngularVel(idBody, angularvelocity.GetFirst(), angularvelocity.GetSecond(), angularvelocity.GetThird());
	}
	else//static object
	{		
		dGeomSetPosition (geomid, position.GetFirst(),position.GetSecond(),position.GetThird());		
	}
	this->bodyid = geomid;
	this->world = world;
	dQuaternion q;
	float c1 = cos(rotation.GetFirst()/2);
	float c2 = cos(rotation.GetSecond()/2);
	float c3 = cos(rotation.GetThird()/2);
	float s1 = sin(rotation.GetFirst()/2);
	float s2 = sin(rotation.GetSecond()/2);
	float s3 = sin(rotation.GetThird()/2);
	q[0] = c1*c2*c3+s1*s2*s3;
	q[1] = s1*c2*c3-c1*s2*s3;
	q[2] = c1*s2*c3 + s1*c2*s3;
	q[3] = c1*c2*s3-s1*s2*c3;
	dGeomSetQuaternion(geomid, q);	
	/*this->RotateObject(1,0,0,rotation.GetFirst()); //roll
	this->RotateObject(0,1,0,rotation.GetSecond());//pitch			
	this->RotateObject(0,0,1,rotation.GetThird()); //yaw*/	
}

ODECylinder::~ODECylinder()
{
}

void ODECylinder::UpdateData()
{
	const dReal *position_aux = dGeomGetPosition (this->GetGeomId());
	Vector3f position;
	position.SetFirst(position_aux[0]);
	position.SetSecond(position_aux[1]);
	position.SetThird(position_aux[2]);
	this->SetPosition(position);
	dQuaternion quat;
	dGeomGetQuaternion(this->bodyid,quat);
	DataQuaternion dataquat(quat[0],quat[1],quat[2],quat[3]);
	this->SetQuaternion(dataquat);
	float sqw,sqx,sqy,sqz;
	sqw = quat[0] * quat[0];
	sqx = quat[1] * quat[1];
	sqy = quat[2] * quat[2];
	sqz = quat[3] * quat[3];
	float roll = (float)atan2l(2.0 * ( quat[2] * quat[3] + quat[1] * quat[0] ) , ( -sqx - sqy + sqz + sqw ));
	float pitch = (float)asinl(-2.0 * ( quat[1] * quat[3] - quat[2] * quat[0] ));
	float yaw = (float)atan2l(2.0 * ( quat[1] * quat[2] + quat[3] * quat[0] ) , (  sqx - sqy - sqz + sqw ));
	Vector3f rotation;
	rotation.SetFirst(roll);
	rotation.SetSecond(pitch);
	rotation.SetThird(yaw);
	this->SetRotation(rotation);
}

DataCylinder *ODECylinder::GetDataCylinder()
{
	if (this->GetMass()>=0)
	{
		const dReal *vel, *ang;
		dBodyID bdyid= dGeomGetBody(this->GetGeomId());
		vel = dBodyGetLinearVel(bdyid);
		ang = dBodyGetAngularVel(bdyid);
		Vector3f linearvelocity(vel[0],vel[1],vel[2]);
		Vector3f angularvelocity(ang[0],ang[1],ang[2]);
		return new DataCylinder(this->GetObjectId(), this->GetRadius(), this->GetLength(),this->GetPosition(),this->GetRotation(), this->GetMaterialId(),this->GetMass(), linearvelocity, angularvelocity);
	}
	else
		return new DataCylinder(this->GetObjectId(), this->GetRadius(), this->GetLength(),this->GetPosition(),this->GetRotation(), this->GetMaterialId(),this->GetMass(), Vector3f(0,0,0),Vector3f(0,0,0));
}

dGeomID ODECylinder::GetGeomId()
{
	return this->bodyid;
}

dWorldID ODECylinder::GetWorldId()
{
	return this->world;
}

void ODECylinder::SetWorldId(dWorldID world)
{
	this->world = world;
}

void ODECylinder::RotateObject(float axis_x, float axis_y, float axis_z, float angle)
{
	if (angle!=0)
	{
		dQuaternion q,oldq,newq;
		dQFromAxisAndAngle (q,axis_x,axis_y,axis_z,angle);
		dGeomGetQuaternion(this->GetGeomId(),oldq);
		dQMultiply0(newq,oldq,q);
		dGeomSetQuaternion (this->GetGeomId(),newq);
	}
}

void ODECylinder::SetPhysicalPosition(float posx, float posy, float posz)
{
	dGeomSetPosition(this->bodyid, posx, posy,posz);
}

Vector3f ODECylinder::GetAngularVelocity()
{
	const dReal *ang;
	dBodyID bodyid= dGeomGetBody(this->GetGeomId());
	ang = dBodyGetAngularVel(bodyid);
	return Vector3f(ang[0],ang[1],ang[2]);
}

Vector3f ODECylinder::GetLinearVelocity()
{
	const dReal *vel;
	dBodyID bodyid= dGeomGetBody(this->GetGeomId());
	vel = dBodyGetLinearVel(bodyid);
	return Vector3f(vel[0],vel[1],vel[2]);
}

}
